var FINFunctions=new Object();

var DEBUG_FINFLOW = false;
var FIN;

if (!FIN)
	FIN = {};

	
//
// Example FINFunction styles - NOT FOR REAL USE
//

// Style 1: Simple JS Function, immediate return, no visual timer
FINFunctions.Example1=function(param)
{
	var returnCode = ""; //Must match a function node NextNode property item. See Niodes.js.
	
	// Do something quick here
	// ...
	returnCode = "Succeed"
	
	FINControl.FunctionReturn(returnCode); // Return control to JS Flow Control engine
}

// Style 2: Complex Function, delayed return return, visual timer
// NOTE: This kind of thing is not practical in JS. Typically not useful.
FINFunctions.Example2=function(param)
{
	var returnCode = ""; //Must match a function node NextNode property item. See Niodes.js.
	
	// Set the timer text that will appear. V1 has only 1 item, and it must be static
	// for the duration of the timer
	FINVars.TimerText = getTrans("General.PleaseWait");
	// Initializes timer, shows relevant UI Elements for timer
	FIN.StartTimer();
	
	// Do something longer
	for(var i=0; i<3; i++)
	{
		// ...
		FIN.UpdateTimer(i/3*100);
	}
	
	returnCode = "Succeed"	
	FIN.UpdateTimer(100);
	
	// End the timer. This hides the relevant UI elements
	FIN.TimerComplete();
	FINControl.FunctionReturn(returnCode); // Return control to JS Flow Control engine
}

// Style 3: Simple Cef Function - immediate return, no visual timer
FINFunctions.Example3=function(param)
{
	var returnCode = "Fail"; //Must match a function node NextNode property item. See Niodes.js.
	
	// Do something quick here
	// Note, in this case, somefakefunction simply returns a value. It does not interact directly with
	// the FIN engine.
	// ...
	if(CefRunning())
		returnCode = cef.test.somefakefunction();
	
	FINControl.FunctionReturn(returnCode); // Return control to JS Flow Control engine
}

// Style 4: Complex Cef function, calls cef function which starts thread, visual timer
FINFunctions.Example4=function(param)
{
	var returnCode = "Fail"; //Must match a function node NextNode property item. See Niodes.js.
	
	// Do something quick here
	// Note, in this case, somefakefunction simply returns a value. It does not interact directly with
	// the FIN engine.
	// ...
	if(CefRunning())
		cef.FixItNow.Test();
	
	// At this point, the flow will pause. We expect control to be returned via cef.FixItNow.Test();
}
/*
// Pseudo C/C++ code for Style 4 corresponding function

// Handler for "Test" call. As per usual Cef call. In this instance, calls a thread, but it doesn't have to.
handler::Execute(...)
{
	if(name == "Test")
	{
		StartThread_Test(...);
	}
}

// In this example, control is in the thread. Thread will process the command, and while doing so,
// will call relevant JS functions in the relevant window (in FIN case, the help window)
TestThrd(...)
{
	ExecuteJSFunction(HelpWindow, "FINStartTimer();");
	ExecuteJSFunction(HelpWindow, "FINUpdateTimer(10);");
	
	// Do something...
	
	ExecuteJSFunction(HelpWindow, "FINUpdateTimer(60);");
	
	// Do something else...

	// Return result. These results are arbitary, and depend on the node we are being
	// called from.
	if(wesucceeded)
		ExecuteJSFunction(HelpWindow, "FINReturn('Succeed');");
	else
		ExecuteJSFunction(HelpWindow, "FINReturn('Fail');");
}

// FINStartTimer, FINUpdateTimer and FINReturn are function located in Help.html, and call into
// the JS functions FIN.StartTimer, FIN.UpdateTimer and FINControl.FunctionReturn.
*/


// There are more ways that these functionality can be combined to affect the outcome of the FIN experience.
// An example below (MobileSimPin) calls a function cef.mobile.EnterPinPuk and does not want to get a direct
// result in this function. But it wants the function to go for 30 seconds before the flow continues. So it
// calls StartDurationTimer(30), which is a helper function that uses JS setTimeout to set a consistent
// timer that goes for exactly 30 seconds, the returns "Succeed".
// Ultimately, the way you use it depends on the context you want to use it.



//
// Real FIN Functions
//	
	
// FINFunctions.MobileSimPin
//
// Set's a 30 second timer and send's the SimPin entered (stored in FINVars.SimPin) to CefApp.
//
FINFunctions.MobileSimPin=function(param)
{
	FINVars.TimerText = getTrans("General.PleaseWait");
	
	StartDurationTimer(30);
	if(CefRunning())
	{
		cef.mobile.EnterPinPuk(FINVars.SimPin,"");
	}
	
	//setTimeout('FINControl.FunctionReturn("Succeed")', 10000);
}	

FINFunctions.MobileSimPuk=function(param)
{
	FINVars.TimerText = getTrans("General.PleaseWait");
	
	StartDurationTimer(30);
	if(CefRunning())
	{
		cef.mobile.EnterPinPuk(FINVars.SimPin,FINVars.SimPuk);
	}
	
	//setTimeout('FINControl.FunctionReturn("Succeed")', 10000);
}	
	
// FINFunctions.SetCurrentResolution
//
// NOT YET WORKING
FINFunctions.SetCurrentResolution=function(param)
{	
	FINVars.TimerText = getTrans("General.PleaseWait");
		
	//Sets the current resolution for logging purposes. This is relevant to the operations previous performed (e.g. this comes after a reboot modem action, with param1: RebootGateway)
	//return "Succeed";
	if(CefRunning())
		cef.FixItNow.Test();
}

// FINFunctions.StartProgramLog
//
// NOT YET WORKING
FINFunctions.StartProgramLog=function(param)
{		
	FINVars.TimerText = getTrans("General.PleaseWait");
	//Starts a FIN log problem. This is typically not required, as FIN:MainTest automatically establishes this.
	//return "Succeed";
	//if(CefRunning())
	//	cef.FixItNow.Test();
	
	FINControl.FunctionReturn("Succeed");
}

// FINFunctions.GetStoredModem
//
// Returns Succeed of we are not roaming, or Fail if we are roaming
// I know... probably should be reversed...
FINFunctions.MobileNotRoaming=function(param)
{
	var isRoaming = false;

	if(CefRunning())
	{
		window.cefWindow.OutputDebugString("FINFunctions.MobileNotRoaming");
		var mobileInfo = cef.mobile.GetInfo();
		isRoaming = (mobileInfo.networkRegistration.registrationStatus == MobileRegistrationStatusRoaming);
	}
	
	if(!isRoaming)
		FINControl.FunctionReturn("Succeed")
	else
		FINControl.FunctionReturn("Fail")
}

// FINFunctions.GetStoredModem
//
// NOT YET WORKING
FINFunctions.GetStoredModem=function(param){
	FINVars.TimerText = getTrans("General.PleaseWait");
	// returns Succeed or Fail
	
	//return "Succeed";
	if(CefRunning())
		cef.FixItNow.Test();
		
	//FINVars.ModemType
}

// FINFunctions.StartSessionLog
//
// NOT YET WORKING
FINFunctions.StartSessionLog=function(param){	
	FINVars.TimerText = getTrans("General.PleaseWait");
	
	//Starts a FIN log session. Sessions contain a 1 or more "problems", which contain 1 or more "resolutions".
	//
	
	//return "Succeed";
	if(CefRunning())
		cef.FixItNow.Test();
	
	
	
}

// FINFunctions.StartProblemLog
//
// NOT YET WORKING
FINFunctions.StartProblemLog=function(param){
	FINVars.TimerText = getTrans("General.PleaseWait");
	//Starts a FIN log problem. This is typically not required, as FIN:MainTest automatically establishes this.
	//return "Succeed";
	if(CefRunning())
		cef.FixItNow.Test();	
	
}

// FINFunctions.FinishSessionLog
//
// NOT YET WORKING
FINFunctions.FinishSessionLog=function(param){

	FINVars.TimerText = getTrans("General.PleaseWait");

	//Finishes a FIN Log session. Not typically needed, as Connection Centre closes the session when the user exits.
	//return "Succeed";
	if(CefRunning())
		cef.FixItNow.Test();
	
}

// FINFunctions.ConnectMobile
// Tries to establish a connection to the internet. ConnectMobile is expected to be a thread
// and call relevant FIN functions to update the timer.
FINFunctions.ConnectMobile=function(param)
{
	FINVars.TimerText = getTrans("General.PleaseWait");
	
	if(CefRunning())
		cef.FixItNow.ConnectMobile();
}

FINFunctions.Log=function(param)
{
	FINControl.FunctionReturn("Succeed");
}

FINFunctions.MobileStateCheckOk=function(param)
{	
	var succeed = true;
	if(CefRunning())
	{
		var mobileInfo = cef.mobile.GetInfo();
		var mobileInfoState = GetMobileState(mobileInfo);
		
		if(param.State == "NoDevice" && mobileInfoState == MobileStateNoDevice)
			succeed = false;
		else if(param.State == "NoSim" && mobileInfoState == MobileStateNoSim)
			succeed = false;
		else if(param.State == "NoNetwork" && mobileInfoState == MobileStateNoNetwork)
			succeed = false;
		else if(param.State == "DeviceInUse" && mobileInfoState == MobileStateDeviceInUse)
			succeed = false;
		else if(param.State == "EnterPIN" && mobileInfoState == MobileStateEnterPin)
			succeed = false;
		else if(param.State == "EnterPUK" && mobileInfoState == MobileStateEnterPuk)
			succeed = false;
		else if(param.State == "UnableToEstablish" &&
				(
					mobileInfoState == MobileStateEnteringPinPuk ||
					mobileInfoState == MobileStateNetworkSearching ||
					mobileInfoState == MobileStateInternetConnected ||
					mobileInfoState == MobileStateInternetConnecting ||
					mobileInfoState == MobileStateInternetDisconnecting ||
					mobileInfoState == MobileStateReady ||
					mobileInfoState == MobileStateUnknown
				)
			)
			succeed = false;			
		else if(param.State == "NoNetwork" && mobileInfoState == MobileStateNoNetwork)
			succeed = false;
		else if(param.State == "NetworkDenied" && mobileInfoState == MobileStateNetworkDenied)
			succeed = false;
		else if(param.State == "NetworkNotRegistered" && mobileInfoState == MobileStateNetworkNotRegistered)
			succeed = false;			
			
		var a = 0;
	}
	
	if(succeed)
		FINControl.FunctionReturn("Succeed");
	else
		FINControl.FunctionReturn("Fail");
}

FINFunctions.IsLowSignalStrength=function(param)
{
	FINVars.TimerText = getTrans("General.PleaseWait");
	
	if(CefRunning())
	{
		var mobileInfo = cef.mobile.GetInfo();
		var mobileInfoState = GetMobileState(mobileInfo);

		if(mobileInfo.signalQuality.signalQualitydBm <= -100)
			FINControl.FunctionReturn("SignalLow");
		else
			FINControl.FunctionReturn("SignalOk");
	}
}

// FINFunctions.MobileState
// Gets the current state of the mobile device. Also, updates some FINVar's internally
// to match key information.
FINFunctions.MobileState=function(param)
{	
	if(DEBUG_FINFLOW)
	{
		FINControl.FunctionReturn('NoDevice');
		return;	
	}
	
	FINVars.TimerText = getTrans("General.PleaseWait");
	
	if(CefRunning())
	{
		var mobileInfo = cef.mobile.GetInfo();
		var mobileInfoState = GetMobileState(mobileInfo);
		
		// Record other information in FINVars for use in screens and desicion points
		FINVars.PINAttemptsRemaining = mobileInfo.simStatus.pinTriesRemaining;
		FINVars.PUKAttemptsRemaining = mobileInfo.simStatus.pukTriesRemaining;
		FINVars.ModemType = mobileInfo.deviceCode;

		// Based on the state, return the relevant FINFlow code
		switch (mobileInfoState)
		{
			case MobileStateNoDevice:
				FINControl.FunctionReturn('NoDevice');
				break;

			case MobileStateDeviceConnecting:
				FINControl.FunctionReturn('NoDevice');
				break;

			case MobileStateDeviceInUse:
				FINControl.FunctionReturn('DeviceInUse');
				break;

			case MobileStateNoSim:
				FINControl.FunctionReturn('NoSim');
				break;

			case MobileStateEnterPin:
				FINControl.FunctionReturn('EnterPIN');
				break;

			case MobileStateEnterPuk:
				FINControl.FunctionReturn('EnterPUK');
				break;

			case MobileStateEnteringPinPuk:
				FINControl.FunctionReturn('UnableToEstablish');
				break;

			case MobileStateNoNetwork:
				FINControl.FunctionReturn('NoNetwork');
				break;

			case MobileStateNetworkDenied:
				FINControl.FunctionReturn('NetworkDenied');
				break;

			case MobileStateNetworkNotRegistered:
				FINControl.FunctionReturn('NetworkNotRegistered');
				break;

			case MobileStateNetworkSearching:
				FINControl.FunctionReturn('UnableToEstablish');
				break;

			case MobileStateInternetConnected:
				FINControl.FunctionReturn('UnableToEstablish');
				break;

			case MobileStateInternetConnecting:
				FINControl.FunctionReturn('UnableToEstablish');
				break;

			case MobileStateInternetDisconnecting:
				FINControl.FunctionReturn('UnableToEstablish');
				break;

			case MobileStateReady:
				FINControl.FunctionReturn('UnableToEstablish');
				break;

			case MobileStateUnknown:
			case NaN:
				FINControl.FunctionReturn('UnableToEstablish');
			default:
				break;
		}
	}
}


// FINFunctions.FINWait
// Sets a timer going, with corresponding timer bar. Timeout is defined in the function
// node (Nodes.js)
FINFunctions.FINWait=function(param)
{
	FINVars.TimerText = getTrans("General.PleaseWait");
	
	StartDurationTimer(param.Timeout);
}
	
	
	
	
	
	
	
	
	
//	
// Special functions
//

// FINFunctions.Counter
// Used interally for counter notes.
FINFunctions.Counter=function(param)
{		
	//FINVars.TimerText = getTrans("General.PleaseWait");	
	FINControl.FunctionReturn(Nodes[FINVars.CurrentNode].AccessCount.toString());
}


// FINFunctions.Finish	
// function executes when Finish button is clicked	
FINFunctions.Finish=function(param)
{	
	FINFunctions.ExitFIN();
}

// FINFunctions.ExitFIN
// Terminates FIN and shows standard Help Window content
FINFunctions.ExitFIN=function(param)
{	
	FINLog.RecordSession();

	$('#MenuContainer').show();
	$('#Back').hide();
	$('#Next').hide();
	$('#Container').hide();
	FINControl.ClearStates(); // clear State arrays
	FINControl.UpdateTesting();// update text fields
	document.getElementById("testingForm").style.display = "none";
	
	if(CefRunning())
	{	
		cef.application.CloseNovusWindow(NovusWindowId_HelpWindow);
	}		
	
	return "Exit";
}


// Notifies the user of text in AlertText paarameter
FINFunctions.AlertUser=function(AlertText)
{
	if(CefRunning())
	{
		window.cefWindow.OutputDebugString("FINFunctions.AlertUser - " + AlertText);
	}
	else
		alert(AlertText);
}




		
		
// FIN.Timer* Functions

FIN.TimerComplete = function TimerComplete()
{
	$('#NavButtons').show();
	FINVars.TimerIsOn = 0;
	$('#progressbar').hide();
}

FIN.StartTimer = function StartTimer()
{
	FINVars.CurrentScreen = "TIMER";
	FINControl.TimerScreen();
	
	FIN.UpdateTimer(0);
	FINVars.TimerIsOn = 0;
	TimerIsOn = 1;
	$('#NavButtons').hide();
	
	$('#progressbar').show();
	
}

FIN.UpdateTimer = function UpdateTimer(val)
{
	setTimerBarProgress(val);
}



function timerCompleteEvent(){
	FIN.TimerComplete();
	FINControl.FunctionReturn('Succeed');
}


// Duration Timer Functions
// These are for internal use only. This initiates an automatic timer screen that runs for a set duration.

// Starts a duration timer
function StartDurationTimer(val)
{
	
	if (!FINVars.TimerIsOn)
	{		
		FIN.StartTimer();
		setTimerBarDuration(val);
	
	}
}



